/*
 * Decompiled with CFR 0.152.
 */
package net.ftb.gui.panes;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.ftb.data.Settings;
import net.ftb.gui.ChooseDir;
import net.ftb.gui.LaunchFrame;
import net.ftb.gui.dialogs.AdvancedOptionsDialog;
import net.ftb.gui.panes.ILauncherPane;
import net.ftb.locale.I18N;
import net.ftb.log.Logger;
import net.ftb.util.OSUtils;
import net.ftb.util.winreg.JavaFinder;
import net.ftb.util.winreg.JavaInfo;

public class OptionsPane
extends JPanel
implements ILauncherPane {
    private JToggleButton tglbtnForceUpdate;
    private JButton installBrowseBtn;
    private JButton advancedOptionsBtn;
    private JButton btnInstallJava = new JButton();
    private JLabel lblJavaVersion;
    private JLabel lblInstallFolder;
    private JLabel lblRamMaximum;
    private JLabel lblLocale;
    private JLabel currentRam;
    private JLabel minecraftSize;
    private JLabel lblX;
    private JLabel lbl32BitWarning = new JLabel();
    private JSlider ramMaximum;
    private JComboBox locale;
    private JTextField installFolderTextField;
    private JCheckBox chckbxShowConsole;
    private JCheckBox keepLauncherOpen;
    private JCheckBox optJavaArgs;
    private JCheckBox useSystemProxy;
    private final Settings settings;
    private FocusListener settingsChangeListener = new FocusListener(){

        @Override
        public void focusLost(FocusEvent e) {
            OptionsPane.this.saveSettingsInto(OptionsPane.this.settings);
        }

        @Override
        public void focusGained(FocusEvent e) {
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OptionsPane(Settings settings) {
        String[] locales;
        this.settings = settings;
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.installBrowseBtn = new JButton("...");
        this.installBrowseBtn.setBounds(786, 11, 49, 28);
        this.installBrowseBtn.addActionListener(new ChooseDir(this));
        this.setLayout(null);
        this.add(this.installBrowseBtn);
        this.lblInstallFolder = new JLabel(I18N.getLocaleString("INSTALL_FOLDER"));
        this.lblInstallFolder.setBounds(10, 11, 127, 28);
        this.add(this.lblInstallFolder);
        this.installFolderTextField = new JTextField();
        this.installFolderTextField.setBounds(147, 11, 629, 28);
        this.installFolderTextField.addFocusListener(this.settingsChangeListener);
        this.installFolderTextField.setColumns(10);
        this.installFolderTextField.setText(settings.getInstallPath());
        this.add(this.installFolderTextField);
        this.tglbtnForceUpdate = new JToggleButton(I18N.getLocaleString("FORCE_UPDATE"));
        this.tglbtnForceUpdate.setBounds(147, 48, 629, 29);
        this.tglbtnForceUpdate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                OptionsPane.this.saveSettingsInto(OptionsPane.this.settings);
            }
        });
        this.tglbtnForceUpdate.getModel().setPressed(settings.isForceUpdateEnabled());
        this.add(this.tglbtnForceUpdate);
        this.currentRam = new JLabel();
        this.currentRam.setBounds(427, 95, 85, 25);
        long ram = OSUtils.getOSTotalMemory();
        long freeram = OSUtils.getOSFreeMemory();
        this.ramMaximum = new JSlider();
        this.ramMaximum.setBounds(190, 95, 222, 25);
        this.ramMaximum.setSnapToTicks(true);
        this.ramMaximum.setMajorTickSpacing(256);
        this.ramMaximum.setMinorTickSpacing(256);
        this.ramMaximum.setMinimum(256);
        Boolean vm64Bits = Settings.getSettings().getCurrentJava().is64bits;
        if (vm64Bits != null) {
            if (vm64Bits.booleanValue()) {
                this.ramMaximum.setMaximum((int)ram);
            } else if (ram < 1024L) {
                this.ramMaximum.setMaximum((int)ram);
            } else if (freeram > 2046L) {
                this.ramMaximum.setMaximum(1536);
            } else {
                this.ramMaximum.setMaximum(1024);
            }
        }
        int ramMax = Integer.parseInt(settings.getRamMax()) > this.ramMaximum.getMaximum() ? this.ramMaximum.getMaximum() : Integer.parseInt(settings.getRamMax());
        this.ramMaximum.setValue(ramMax);
        this.currentRam.setText(this.getAmount());
        this.ramMaximum.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                OptionsPane.this.currentRam.setText(OptionsPane.this.getAmount());
            }
        });
        this.ramMaximum.addFocusListener(this.settingsChangeListener);
        this.lblRamMaximum = new JLabel(I18N.getLocaleString("RAM_MAX"));
        this.lblRamMaximum.setBounds(10, 95, 195, 25);
        this.add(this.lblRamMaximum);
        this.add(this.ramMaximum);
        this.add(this.currentRam);
        HashMap<Integer, String> hashMap = I18N.localeIndices;
        synchronized (hashMap) {
            locales = new String[I18N.localeIndices.size()];
            for (Map.Entry<Integer, String> entry : I18N.localeIndices.entrySet()) {
                Logger.logInfo("[i18n] Added " + entry.getKey().toString() + " " + entry.getValue() + " to options pane");
                locales[entry.getKey().intValue()] = I18N.localeFiles.get(entry.getValue());
            }
        }
        this.locale = new JComboBox<String>(locales);
        this.locale.setBounds(190, 130, 222, 25);
        this.locale.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                I18N.setLocale(I18N.localeIndices.get(OptionsPane.this.locale.getSelectedIndex()));
                if (LaunchFrame.getInstance() != null) {
                    LaunchFrame.getInstance().updateLocale();
                }
            }
        });
        this.locale.addFocusListener(this.settingsChangeListener);
        this.locale.setSelectedItem(I18N.localeFiles.get(settings.getLocale()));
        this.lblLocale = new JLabel(I18N.getLocaleString("LANGUAGE"));
        this.lblLocale.setBounds(10, 130, 195, 25);
        this.add(this.lblLocale);
        this.add(this.locale);
        this.updateJavaLabels();
        this.chckbxShowConsole = new JCheckBox(I18N.getLocaleString("SHOW_CONSOLE"));
        this.chckbxShowConsole.addFocusListener(this.settingsChangeListener);
        this.chckbxShowConsole.setSelected(settings.getConsoleActive());
        this.chckbxShowConsole.setBounds(540, 95, 183, 25);
        this.add(this.chckbxShowConsole);
        this.keepLauncherOpen = new JCheckBox(I18N.getLocaleString("REOPEN_LAUNCHER"));
        this.keepLauncherOpen.setBounds(540, 130, 300, 25);
        this.keepLauncherOpen.setSelected(settings.getKeepLauncherOpen());
        this.keepLauncherOpen.addFocusListener(this.settingsChangeListener);
        this.add(this.keepLauncherOpen);
        this.optJavaArgs = new JCheckBox(I18N.getLocaleString("OPT_JAVA_ARGS"));
        this.optJavaArgs.setBounds(540, 165, 300, 25);
        this.optJavaArgs.setSelected(settings.getOptJavaArgs());
        this.optJavaArgs.addFocusListener(this.settingsChangeListener);
        this.add(this.optJavaArgs);
        this.useSystemProxy = new JCheckBox(I18N.getLocaleString("USE_SYSTEM_PROXY"));
        this.useSystemProxy.setBounds(540, 200, 300, 25);
        this.useSystemProxy.setSelected(settings.getUseSystemProxy());
        this.useSystemProxy.addFocusListener(this.settingsChangeListener);
        this.add(this.useSystemProxy);
        this.advancedOptionsBtn = new JButton(I18N.getLocaleString("ADVANCED_OPTIONS"));
        this.advancedOptionsBtn.setBounds(147, 275, 629, 29);
        this.advancedOptionsBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AdvancedOptionsDialog aod = new AdvancedOptionsDialog();
                aod.setVisible(true);
            }
        });
        this.advancedOptionsBtn.getModel().setPressed(settings.isForceUpdateEnabled());
        this.add(this.advancedOptionsBtn);
        if ((OSUtils.getCurrentOS().equals((Object)OSUtils.OS.WINDOWS) || OSUtils.getCurrentOS().equals((Object)OSUtils.OS.MACOSX)) && JavaFinder.parseJavaVersion() != null && JavaFinder.parseJavaVersion().path != null) {
            this.lblJavaVersion = new JLabel("Java version: " + JavaFinder.parseJavaVersion().origVersion);
            this.lblJavaVersion.setBounds(15, 276, 250, 25);
            this.add(this.lblJavaVersion);
        }
    }

    public void setInstallFolderText(String text) {
        this.installFolderTextField.setText(text);
        this.saveSettingsInto(this.settings);
    }

    public void saveSettingsInto(Settings settings) {
        settings.setInstallPath(this.installFolderTextField.getText());
        settings.setForceUpdateEnabled(this.tglbtnForceUpdate.isSelected());
        settings.setRamMax(String.valueOf(this.ramMaximum.getValue()));
        settings.setLocale(I18N.localeIndices.get(this.locale.getSelectedIndex()));
        settings.setConsoleActive(this.chckbxShowConsole.isSelected());
        settings.setOptJavaArgs(this.optJavaArgs.isSelected());
        settings.setKeepLauncherOpen(this.keepLauncherOpen.isSelected());
        settings.setUseSystemProxy(this.useSystemProxy.isSelected());
        settings.save();
    }

    public void updateLocale() {
        this.lblInstallFolder.setText(I18N.getLocaleString("INSTALL_FOLDER"));
        this.tglbtnForceUpdate.setText(I18N.getLocaleString("FORCE_UPDATE"));
        this.lblRamMaximum.setText(I18N.getLocaleString("RAM_MAX"));
        this.lblLocale.setText(I18N.getLocaleString("LANGUAGE"));
    }

    private String getAmount() {
        int ramMax = this.ramMaximum.getValue();
        return ramMax >= 1024 ? Math.round(ramMax / 256 / 4) + "." + ramMax / 256 % 4 * 25 + " GB" : ramMax + " MB";
    }

    @Override
    public void onVisible() {
    }

    public void addUpdateJREButton(final String webLink, String unlocMessage) {
        this.btnInstallJava.setText(I18N.getLocaleString(unlocMessage));
        this.btnInstallJava.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                OSUtils.browse(webLink);
            }
        });
        this.btnInstallJava.setBounds(345, 210, 150, 28);
        this.add(this.btnInstallJava);
    }

    public void addUpdateLabel(String unlocMessage) {
        this.lbl32BitWarning.setText(I18N.getLocaleString(unlocMessage));
        this.lbl32BitWarning.setBounds(147, 180, 600, 25);
        this.lbl32BitWarning.setForeground(Color.red);
        this.add(this.lbl32BitWarning);
    }

    public void updateJavaLabels() {
        this.remove(this.lbl32BitWarning);
        this.remove(this.btnInstallJava);
        JavaInfo java = Settings.getSettings().getCurrentJava();
        if (java.getMajor() < 1 || java.getMajor() == 1 && java.getMinor() < 7) {
            if (OSUtils.getCurrentOS().equals((Object)OSUtils.OS.MACOSX)) {
                if (JavaFinder.java8Found) {
                    this.addUpdateJREButton("http://javadl.sun.com/webapps/download/AutoDL?BundleId=87438", "DOWNLOAD_JAVAGOOD");
                    this.addUpdateLabel("JAVA_NEW_Warning");
                } else if (OSUtils.canRun7OnMac()) {
                    this.addUpdateJREButton("http://javadl.sun.com/webapps/download/AutoDL?BundleId=87438", "DOWNLOAD_JAVAGOOD");
                    this.addUpdateLabel("JAVA_OLD_Warning");
                }
            } else if (OSUtils.is64BitOS()) {
                if (OSUtils.getCurrentOS().equals((Object)OSUtils.OS.WINDOWS)) {
                    this.addUpdateJREButton("http://javadl.sun.com/webapps/download/AutoDL?BundleId=87443", "DOWNLOAD_JAVA64");
                    this.addUpdateLabel("JAVA_OLD_Warning");
                } else if (OSUtils.getCurrentOS().equals((Object)OSUtils.OS.UNIX)) {
                    this.addUpdateJREButton("http://javadl.sun.com/webapps/download/AutoDL?BundleId=87437", "DOWNLOAD_JAVA64");
                    this.addUpdateLabel("JAVA_OLD_Warning");
                }
            } else if (OSUtils.getCurrentOS().equals((Object)OSUtils.OS.WINDOWS)) {
                this.addUpdateJREButton("http://javadl.sun.com/webapps/download/AutoDL?BundleId=86895", "DOWNLOAD_JAVA32");
                this.addUpdateLabel("JAVA_OLD_Warning");
            } else if (OSUtils.getCurrentOS().equals((Object)OSUtils.OS.UNIX)) {
                this.addUpdateJREButton("http://javadl.sun.com/webapps/download/AutoDL?BundleId=87435", "DOWNLOAD_JAVA32");
                this.addUpdateLabel("JAVA_OLD_Warning");
            }
        } else if (OSUtils.getCurrentOS().equals((Object)OSUtils.OS.MACOSX) && (java.getMajor() > 1 || java.getMinor() > 7)) {
            this.addUpdateJREButton("http://javadl.sun.com/webapps/download/AutoDL?BundleId=87438", "DOWNLOAD_JAVAGOOD");
            this.addUpdateLabel("JAVA_NEW_Warning");
        } else if (!Settings.getSettings().getCurrentJava().is64bits) {
            this.addUpdateLabel("JAVA_32BIT_WARNING");
            if (OSUtils.getCurrentOS().equals((Object)OSUtils.OS.WINDOWS) && OSUtils.is64BitWindows()) {
                this.addUpdateJREButton("http://javadl.sun.com/webapps/download/AutoDL?BundleId=87443", "DOWNLOAD_JAVA64");
            }
        }
        this.repaint();
    }

    public void updateShowConsole() {
        this.chckbxShowConsole.setSelected(this.settings.getConsoleActive());
    }
}

